/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.zend.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.ui.actions.IWatchExpressionFactoryAdapter;
import org2.eclipse.php.internal.debug.core.Logger;
import org2.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org2.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org2.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org2.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org2.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org2.eclipse.php.internal.debug.core.zend.model.PHPValue;
import org2.eclipse.php.internal.debug.core.zend.model.WatchExpressionFactoryAdapter;

public class PHPVariable
extends PHPDebugElement
implements IVariable {
    private Expression variable;
    private PHPValue pValue;
    private boolean hasChanged = false;
    private boolean global = false;

    public PHPVariable(PHPDebugTarget target, Expression var) {
        super(target);
        this.variable = var;
        this.global = false;
        this.pValue = new PHPValue(target, this.variable);
    }

    public PHPVariable(PHPDebugTarget target, Expression var, boolean global) {
        super(target);
        this.variable = var;
        this.global = global;
        this.pValue = new PHPValue(target, this.variable, global);
    }

    public IValue getValue() throws DebugException {
        this.hasChanged = false;
        return this.pValue;
    }

    public String getName() throws DebugException {
        return this.variable.getLastName();
    }

    public String getReferenceTypeName() throws DebugException {
        return this.pValue.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return this.hasChanged;
    }

    public void setValue(String expression) throws DebugException {
        boolean status;
        PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
        DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
        Expression changeVar = this.variable;
        if (this.global) {
            String exp = "$GLOBALS[\"" + this.variable.getFullName().substring(1) + "\"]";
            changeVar = new DefaultExpression(exp);
        }
        if (!(status = expressionManager.assignValue(changeVar, expression, 1))) {
            Logger.debugMSG("[" + (Object)((Object)this) + "] PHPValue: Problem changing variable value");
        }
        expressionManager.update(changeVar, 1);
        this.pValue.updateValue(changeVar.getValue());
        this.fireChangeEvent(512);
    }

    public void setValue(IValue value) throws DebugException {
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PHPVariable)) {
            return false;
        }
        PHPVariable variable = (PHPVariable)((Object)obj);
        if (!variable.getDebugTarget().equals(this.getDebugTarget())) {
            return false;
        }
        if (!variable.variable.getFullName().equals(this.variable.getFullName())) {
            return false;
        }
        IValue myValue = null;
        IValue otherValue = null;
        try {
            myValue = this.getValue();
            otherValue = variable.getValue();
        }
        catch (DebugException debugException) {}
        return myValue == otherValue || myValue != null && myValue.equals(otherValue);
    }

    public int hashCode() {
        int valueHash = 0;
        valueHash = this.pValue.hashCode();
        return this.getDebugTarget().hashCode() + valueHash + this.variable.getFullName().hashCode();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWatchExpressionFactoryAdapter.class) {
            return new WatchExpressionFactoryAdapter();
        }
        return super.getAdapter(adapter);
    }
}

